' Demonstrationsprogramm fr TCP/IP unter DOS aus QuickBASIC heraus:
' Oberprimitiver Telnet-Client
' (c) 2000 by Andreas Meile, CH-8242 Hofen SH
' e-Mail: andreas@hofen.ch  WWW: http://www.hofen.ch/~andreas/

' $INCLUDE: 'qb.bi'

DIM dosIntEin AS RegType, dosIntAus AS RegType

' Testen, ob Waterloo TCP mit DOSISODE-Interface geladen wurde
dosIntEin.ax = &HE00  ' SI_CHECKLOAD
CALL INTERRUPT(&H17, dosIntEin, dosIntAus)
IF dosIntAus.cx <> &H1234 THEN
	PRINT "Sie mssen noch SOCKETS.EXE zusammen mit dem Packet Driver"
	PRINT "Ihrer Netzwerkkarte laden"
	END
END IF

DO
	INPUT "IP-Adresse des Hostes (z.B. 192.168.0.2)"; ipAdr$
	' R und S sind eigentlich nur "Notngel", um im Falle eines
	' unordnungsgemssen Abbruchs den Socket schliessen zu knnen
	ipBin$ = ""
	SELECT CASE ipAdr$
	CASE "s", "S"
		GOSUB Schliessen
		PRINT "SI_CLOSE ausgefhrt"
	CASE "r", "R"
		GOSUB Beenden
		PRINT "SI_SHUTDOWN ausgefhrt"
	CASE ELSE
		DO
			p% = INSTR(ipAdr$, ".")
		IF p% = 0 THEN EXIT DO
			ipBin$ = ipBin$ + CHR$(VAL(LEFT$(ipAdr$, p% - 1)))
			ipAdr$ = MID$(ipAdr$, p% + 1)
		LOOP
		ipBin$ = ipBin$ + CHR$(VAL(ipAdr$))
	END SELECT
LOOP UNTIL LEN(ipBin$) = 4
INPUT "Portnummer (z.B. 23=UNIX-Telnet-Sitzung, 80=WWW-Server)"; portNr%

' Initialisieren
dosIntEin.ax = &H300  ' SI_SOCKET
dosIntEin.cx = 1      ' Typ: 1=Stream (TCP), 2=Dgram (UDP)
dosIntEin.dx = 1      ' Socket-ID = 1
CALL INTERRUPT(&H17, dosIntEin, dosIntAus)
IF dosIntAus.ax <> 0 THEN
	PRINT "Fehler beim Initialisieren"
	PRINT "Code:"; dosIntEin.cx
	END
END IF
PufSeg% = dosIntAus.cx
PufOffs% = dosIntAus.dx
DEF SEG = PufSeg%
PRINT "Socket erzeugt"

' Socket aufbauen
dosIntEin.ax = &H500   ' SI_CONNECT
dosIntEin.dx = 1
rsockaddr$ = RIGHT$(MKI$(portNr%), 1) + LEFT$(MKI$(portNr%), 1) + ipBin$
' Daten bertragen: Nur ab dos_buffer+2 ndern
FOR i% = 1 TO LEN(rsockaddr$)
	POKE PufOffs% + i% + 1, ASC(MID$(rsockaddr$, i%, 1))
NEXT i%
CALL INTERRUPT(&H17, dosIntEin, dosIntAus)
IF dosIntAus.ax <> 0 THEN
	PRINT "Fehler beim Verbindungsaufbau"
	PRINT "Code: "; dosIntAus.cx
	GOSUB Beenden
	END
END IF
PRINT "Verbunden"

' Socket steht :-) => Warten, bis man "exit" eingibt (der UNIX-Telnet-Daemon
' schliesst dann von sich aus) oder der HTTPD ebenfalls mit bertragen fertig
' ist

' Zuerst noch sog. Non-Blocking IO aktivieren, damit Tastatur und Netzwerk-
' Socket zusammen abgefragt werden knnen

dosIntEin.ax = &HB00  ' SI_IOCTL
dosIntEin.dx = 1      ' Socket-ID
CALL INTERRUPT(&H17, dosIntEin, dosIntAus)
PRINT "Bereit fr Eingaben"

Drinbleib% = -1
WHILE Drinbleib%
	' Netzwerk-Verbindung prfen
	dosIntEin.ax = &H800  ' SI_RECVFROM
	dosIntEin.cx = 200 ' maximal 200 Zeichen entgegennehmen
	dosIntEin.dx = 1   ' Socket-ID
	CALL INTERRUPT(&H17, dosIntEin, dosIntAus)
	IF dosIntAus.ax = -1 THEN
		IF dosIntAus.cx = 35 THEN
			' EWOULDBLOCK ignorieren (warten!)
		ELSEIF dosIntAus.cx = 6 THEN
			' EBADF als vom Partner ausgelstes close() behandeln
			PRINT "Verbindung vom Partner geschlossen"
			Drinbleib% = 0
		ELSE
			PRINT "Fehler beim Lesen"
			PRINT "Code:"; dosIntAus.cx
			GOSUB Schliessen
			GOSUB Beenden
			END
		END IF
	ELSE
		FOR i% = 0 TO dosIntAus.ax - 1
			z$ = CHR$(PEEK(PufOffs% + 16 + i%))
			' COLOR 5
			' PRINT ASC(z$);
			' COLOR 7
			PRINT z$;
		NEXT i%
	END IF
 
	' Tastatur prfen
	t$ = INKEY$
	IF t$ = CHR$(29) THEN
		Drinbleib% = 0
	ELSEIF t$ <> "" THEN
		WHILE t$ <> ""
			dosIntEin.ax = &H900   ' SI_SENDTO
			dosIntEin.cx = LEN(t$) ' Anzahl Zeichen
			dosIntEin.dx = 1 ' Socket-ID
			FOR i% = 0 TO LEN(t$) - 1
				POKE PufOffs% + 16 + i%, ASC(MID$(t$, i% + 1, 1))
			NEXT i%
			CALL INTERRUPT(&H17, dosIntEin, dosIntAus)
			IF dosIntAus.ax < 0 THEN
				PRINT "Fehler beim Schreiben"
				PRINT "Code"; dosIntAus.cx
				GOSUB Schliessen
				GOSUB Beenden
				END
			END IF
			t$ = MID$(t$, dosIntAus.ax + 1)
		WEND
	END IF
WEND

' Beenden
GOSUB Schliessen
GOSUB Beenden
PRINT "Telnet-Sitzung beendet."
END

Schliessen:
' Zum Schluss Socket schliessen
dosIntEin.ax = &HC00  ' SI_CLOSE
dosIntEin.dx = 1      ' Socket-ID
CALL INTERRUPT(&H17, dosIntEin, dosIntAus)
IF dosIntAus.ax <> 0 THEN
	PRINT "Fehler beim Schliessen"
	PRINT "Code:"; dosIntAus.cx
	GOSUB Beenden
	END
END IF
RETURN

Beenden:
' Netzwerk-Anwendung ganz beenden
dosIntEin.ax = &HD00  ' SI_SHUTDOWN
CALL INTERRUPT(&H17, dosIntEin, dosIntAus)
RETURN

