' Zelda - Geschicklichkeitsspiel hnlich wie Wurmi
' Ursprngliches Programm: (c) 1999 by Mario Altmann
' Verbesserungen (c) 1999 by Andreas Meile, CH-8242 Hofen SH
' e-Mail: andreas@hofen.ch  WWW: http://www.hofen.ch/~andreas/

' Datenstrukturen - machen das Programm vom Software-Design wesentlich
' schner :-) und bersichtlicher ;-) => in objektorientierten Programmier-
' sprachen arbeitet man nur noch so!

TYPE Feind
  x AS INTEGER
  y AS INTEGER
  geschKat AS INTEGER
  naechstBew AS SINGLE
  istGefressen AS INTEGER
  endeGefressen AS SINGLE
END TYPE

' Fr Mini-Fensterverwaltung
TYPE Fenster
  x1 AS INTEGER
  x2 AS INTEGER
  y1 AS INTEGER
  y2 AS INTEGER
  cx AS INTEGER
  cy AS INTEGER
END TYPE

DECLARE FUNCTION FuehrNull$ (w%, B%)
DECLARE FUNCTION RichtungMoeglich% (xPos%, yPos%, istFeind%, ri%)
DECLARE FUNCTION GenerierePasswort$ (n%)
DECLARE FUNCTION PruefePasswort% (pwd$)
DECLARE SUB ZeichneFeind (fei AS Feind)
DECLARE SUB SpeichereLevel ()
DECLARE SUB LadeLevel ()
DECLARE SUB ErzeugeFenster (f AS Fenster)
DECLARE SUB LoescheFenster (f AS Fenster)
DECLARE SUB PrintFenster (f AS Fenster, t$)
DECLARE SUB PrintFensterLn (f AS Fenster, t$)
DECLARE SUB PrintSpezZei (z%)
DECLARE SUB AktualisierePerlen (i%)
DECLARE SUB AktualisiereSchluessel (n%, i%)
DECLARE SUB AktualisiereZeit (i%)
DECLARE SUB AktualisierePillenzeit (i%)
DECLARE SUB Meldung (t$)
DECLARE SUB ZeichneLevel (FuerSpiel%)
DECLARE SUB LoescheLevel ()
DECLARE SUB ZeichneZelle (x%, y%)

' Levelspeicher

DIM SHARED f%(1 TO 39, 2 TO 25), xSp%, ySp%, fe(1 TO 100) AS Feind
DIM SHARED Zch%(58), fa%(58), fh%(58), AnzPerl%, AnzFei%, Zeit%
DIM SHARED PillenZeit%, AnzSchl%(4), Snd%, AktLevel%
DIM SHARED FoerdbGesch!(4), FeindGeschw!(4), PillWirk%(4)
DIM SHARED sx%(3), sy%(3), tFoerdb!(4)

DIM fen AS Fenster

' Liste mit Zeichenelemente fr Bildschirmdarstellung
FOR i% = 0 TO 58
  READ Zch%(i%), fa%(i%), fh%(i%)
NEXT i%
' Werte von f%(): Jedes Element entspricht einer Positionszelle
' 0..11 Pfeile:
'   0..3  (Richtungen >^<V): Seitliches Ein- und Ausspringen mglich
DATA 26, 7, 1, 24, 7, 1, 27, 7, 1, 25, 7, 1
'   4..7 dito, nur seitl. Einspringen erlaubt
DATA 26, 12, 1, 24, 12, 1, 27, 12, 1, 25, 12, 1
'   8..11 dito, ohne seitliches Ein- und Ausspringen
DATA 26, 10, 1, 24, 10, 1, 27, 10, 1, 25, 10, 1
' 12..31 = Frderband: treibt Spieler in die entsprechende Richtung
' und Geschwindigkeit: 12..15 = langsam, 28..31 = schnell => 5 Stufen
' in jeder Stufe alle 4 Richtungen: 12=>, 13=^, 14=<, 15=V usw.
DATA 16, 9, 7, 30, 9, 7, 17, 9, 7, 31, 9, 7
DATA 16, 5, 7, 30, 5, 7, 17, 5, 7, 31, 5, 7
DATA 16, 6, 7, 30, 6, 7, 17, 6, 7, 31, 6, 7
DATA 16, 2, 7, 30, 2, 7, 17, 2, 7, 31, 2, 7
DATA 16, 14, 7, 30, 14, 7, 17, 14, 7, 31, 14, 7
' 32 = leeres Feld
DATA 32, 7, 0
' 33 = undurchdringbare Wand
DATA 219, 8, 7
' 34 = Ziel (kommt man erst hinein, wenn man alle Pillen aufgesammelt hat!)
DATA 127, 15, 3
' 35..39 = Kraftpille wie bei PacMan (35=lngste Wirkungsdauer, 39=krzeste)
DATA 7, 9, 0, 7, 13, 0, 7, 5, 0, 7, 4, 0, 7, 14, 0
' 40 = Perle
DATA 4, 11, 0
' 41 = Zeitbonus +5 Sekunden
DATA 6, 3, 0
' 42 = Super-Ziel (kommt man zu jeder Zeit hinein)
DATA 127, 5, 3
' 43..47 = zugehrige Schlssel (5 Farben)
DATA 235, 10, 0, 235, 11, 0, 235, 9, 0, 235, 13, 0, 235, 12, 0
' 48 = stationre Falle
DATA 35, 14, 0
' 49..53 = verschlossene Tr (5 Farben)
DATA 178, 2, 0, 178, 3, 0, 178, 1, 0, 178, 5, 0, 178, 4, 0
' 54..58 = Feinde (54 = am langsamsten, 58 = am schnellsten)
DATA 2, 2, 0, 2, 10, 0, 2, 4, 0, 2, 12, 0, 2, 14, 0

' Geschwindigkeitskonstanten aller beweglichen Teile
FOR i% = 0 TO 4
  FoerdbGesch!(i%) = .5 ^ (CSNG(4 - i%) / 4!) * .03 ^ (CSNG(i%) / 4!)
  FeindGeschw!(i%) = .6 ^ (CSNG(4 - i%) / 4!) * .1 ^ (CSNG(i%) / 4!)
  PillWirk%(i%) = CINT(25! ^ (CSNG(4 - i%) / 4!) * 5! ^ (CSNG(i%) / 4!))
NEXT i%

' Richtungsvektoren
sx%(0) = 1
sy%(0) = 0
FOR i% = 1 TO 3
  sx%(i%) = sy%(i% - 1)
  sy%(i%) = -sx%(i% - 1)
NEXT i%

SCREEN 0
WIDTH 40, 25   ' Textmodus reicht aus
COLOR 7, 0, 0
CLS

' +-------------------------------+
' | Titel und allgemeiner Verlauf |
' +-------------------------------+

pwd$ = GenerierePasswort$(1)  ' Zu Beginn Level 1-Passwort
Snd% = -1
DO
  COLOR 7, 0, 0
  CLS
  LOCATE 3, 5, 0
  COLOR 9
  PRINT "Zelda 2 - die Jagd nach Juwelen"
  LOCATE 4, 8
  COLOR 2
  PRINT "(c) 1999 by Andreas Meile"
  LOCATE 5, 9
  COLOR 4
  PRINT "e-Mail: ";
  COLOR 11
  PRINT "andreas@hofen.ch"
  LOCATE 6, 4
  COLOR 4
  PRINT "WWW: ";
  COLOR 11
  PRINT "http://www.hofen.ch/~andreas/"
  LOCATE 8, 11
  COLOR 14
  PRINT "Whle aus:"
  LOCATE 10, 11
  COLOR 1, 7
  PRINT "F1";
  COLOR 6, 0
  PRINT " Spiel"
  LOCATE 12, 11
  COLOR 1, 7
  PRINT "F2";
  COLOR 6, 0
  PRINT " Editor"
  LOCATE 14, 11
  COLOR 1, 7
  PRINT "F3";
  COLOR 6, 0
  PRINT " Anleitung"
  LOCATE 16, 11
  COLOR 1, 7
  PRINT "F4";
  COLOR 6, 0
  PRINT " Ende"

  DO
    DO
      tt$ = INKEY$
    LOOP WHILE tt$ = ""
    SELECT CASE tt$
    CASE CHR$(0) + ";"
      GOSUB Spielen
    CASE CHR$(0) + "<"
      GOSUB Editor
    CASE CHR$(0) + "="
      GOSUB Anleitung
    CASE "S", "s"
      Snd% = NOT Snd%
    END SELECT
  LOOP UNTIL tt$ >= CHR$(0) + ";" AND tt$ <= CHR$(0) + ">"
LOOP UNTIL tt$ = CHR$(0) + ">"

WIDTH 80, 25
COLOR 7, 0, 0
CLS
PRINT "Zelda 2 beendet."
END

' +--------------+
' | Level-Editor |
' +--------------+
Editor:
AktLevel% = 1
Zch%(33) = 178   ' damit Cursor sichtbar bleibt
LoescheLevel
COLOR 7, 0
CLS
ZeichneLevel 0
xCu% = 20
yCu% = 13
xEck% = 20
yEck% = 13
AktEl% = 33
MalModus% = 0
LOCATE 1, 1
COLOR 4, 7
PRINT "F1";
COLOR 15, 0
PRINT "=Hilfe";
COLOR 7
PRINT " Aktuelles Element:";
GOSUB FuehreElement
GOSUB FuehreMalmodus
DO
  LOCATE yCu%, xCu%, 1, 2, 7
  DO
    t$ = INKEY$
  LOOP WHILE t$ = ""
  LOCATE , , 0
  SELECT CASE t$
  CASE CHR$(0) + "K"
    IF MalModus% THEN
      IF AktEl% < 32 THEN
        AktEl% = AktEl% AND -4 OR 2
        GOSUB FuehreElement
      END IF
      f%(xCu%, yCu%) = AktEl%
      ZeichneZelle xCu%, yCu%
    END IF
    xCu% = xCu% - 1
    IF xCu% < 2 THEN
      xCu% = 38
    END IF
  CASE CHR$(0) + "M"
    IF MalModus% THEN
      IF AktEl% < 32 THEN
        AktEl% = AktEl% AND -4
        GOSUB FuehreElement
      END IF
      f%(xCu%, yCu%) = AktEl%
      ZeichneZelle xCu%, yCu%
    END IF
    xCu% = xCu% + 1
    IF xCu% > 38 THEN
      xCu% = 2
    END IF
  CASE CHR$(0) + "H"
    IF MalModus% THEN
      IF AktEl% < 32 THEN
        AktEl% = AktEl% AND -4 OR 1
        GOSUB FuehreElement
      END IF
      f%(xCu%, yCu%) = AktEl%
      ZeichneZelle xCu%, yCu%
    END IF
    yCu% = yCu% - 1
    IF yCu% < 3 THEN
      yCu% = 24
    END IF
  CASE CHR$(0) + "P"
    IF MalModus% THEN
      IF AktEl% < 32 THEN
        AktEl% = AktEl% OR 3
        GOSUB FuehreElement
      END IF
      f%(xCu%, yCu%) = AktEl%
      ZeichneZelle xCu%, yCu%
    END IF
    yCu% = yCu% + 1
    IF yCu% > 24 THEN
      yCu% = 3
    END IF
  CASE CHR$(13)
    f%(xCu%, yCu%) = AktEl%
    ZeichneZelle xCu%, yCu%
  CASE " "
    ' Whlen
    COLOR 1, 7
    fen.x1 = 8: fen.x2 = 17
    fen.y1 = 6: fen.y2 = 15
    ErzeugeFenster fen
    FOR i% = 0 TO 7
      LOCATE 7 + i%, 9
      FOR j% = 0 TO 7
        el% = 8 * i% + j%
        IF el% <= 58 THEN
          COLOR fa%(el%), fh%(el%)
          PrintSpezZei Zch%(el%)
        END IF
      NEXT j%
    NEXT i%
    x% = AktEl% AND 7
    y% = AktEl% \ 8
    DO
      LOCATE 7 + y%, 9 + x%, 1
      DO
        t2$ = INKEY$
      LOOP WHILE t2$ = ""
      LOCATE , , 0
      SELECT CASE t2$
      CASE CHR$(0) + "K"
        x% = x% - 1 AND 7
      CASE CHR$(0) + "M"
        x% = x% + 1 AND 7
      CASE CHR$(0) + "H"
        y% = y% - 1 AND 7
      CASE CHR$(0) + "P"
        y% = y% + 1 AND 7
      END SELECT
      el% = 8 * y% + x%
    LOOP UNTIL t2$ = CHR$(27) OR (t2$ = CHR$(13) OR t2$ = " ") AND el% <= 58
    IF t2$ <> CHR$(27) THEN
      AktEl% = el%
      GOSUB FuehreElement
    END IF
    LoescheFenster fen
  CASE "M", "m"
    MalModus% = NOT MalModus%
    GOSUB FuehreMalmodus
  CASE "1"
    xEck% = xCu%
    yEck% = yCu%
  CASE "2"
    IF xCu% > xEck% THEN
      x1% = xEck%
      x2% = xCu%
    ELSE
      x1% = xCu%
      x2% = xEck%
    END IF
    IF yCu% > yEck% THEN
      y1% = yEck%
      y2% = yCu%
    ELSE
      y1% = yCu%
      y2% = yEck%
    END IF
    FOR i% = y1% TO y2%
      FOR j% = x1% TO x2%
        f%(j%, i%) = AktEl%
        ZeichneZelle j%, i%
      NEXT j%
    NEXT i%
  CASE "R", "r"
    ' Automatische Perlenverteilung:
    ' Mit Zufallsgenerator 10% der Felder fllen
    FOR i% = 3 TO 24
      FOR j% = 2 TO 38
        IF (j% <> xSp% OR i% <> ySp%) AND (f%(j%, i%) = 32 OR f%(j%, i%) = 40) THEN
          IF RND > .1 THEN
            f%(j%, i%) = 32
          ELSE
            f%(j%, i%) = 40
          END IF
          ZeichneZelle j%, i%
        END IF
      NEXT j%
    NEXT i%
  CASE "P", "p"
    x1% = xSp%
    y1% = ySp%
    xSp% = xCu%
    ySp% = yCu%
    ZeichneZelle x1%, y1%
    ZeichneZelle xCu%, yCu%
  CASE "T", "t"
    COLOR 5, 7
    fen.x1 = 4: fen.x2 = 35
    fen.y1 = 8: fen.y2 = 12
    ErzeugeFenster fen
    PrintFensterLn fen, "Aktuelle Spielzeit:" + STR$(Zeit%) + " Sek."
    PrintFensterLn fen, "Neue Spielzeit [Sek.] (0=kein"
    PrintFenster fen, "Zeitlimit)"
    INPUT Zeit%
    LoescheFenster fen
  CASE "L", "l"
    COLOR 5, 7
    fen.x1 = 4: fen.x2 = 35
    fen.y1 = 8: fen.y2 = 12
    ErzeugeFenster fen
    PrintFensterLn fen, "Aktueller Level:" + STR$(AktLevel%)
    PrintFenster fen, "Zu ladender Level"
    INPUT AktLevel%
    LadeLevel
    ZeichneLevel 0
  CASE "S", "s"
    COLOR 5, 7
    fen.x1 = 4: fen.x2 = 35
    fen.y1 = 8: fen.y2 = 12
    ErzeugeFenster fen
    PrintFensterLn fen, "Aktueller Level:" + STR$(AktLevel%)
    PrintFenster fen, "Level speichern als"
    INPUT AktLevel%
    SpeichereLevel
    ZeichneLevel 0
    LoescheFenster fen
  CASE "C", "c"
    LoescheLevel
    ZeichneLevel 0
  CASE CHR$(0) + ";"
    ' Online-Hilfe
    COLOR 4, 7
    fen.x1 = 3: fen.x2 = 37
    fen.y1 = 4: fen.y2 = 18
    ErzeugeFenster fen
    PrintFensterLn fen, "Pfeiltasten  = Cursor bewegen"
    PrintFensterLn fen, "Eingabetaste = Element zeichnen"
    PrintFensterLn fen, "Leertaste    = Element auswhlen"
    PrintFensterLn fen, "M            = Malmodus ein/aus"
    PrintFensterLn fen, "1            = Ecke plazieren"
    PrintFensterLn fen, "2            = Rechteck zeichnen"
    PrintFensterLn fen, "R            = autom. Perlenvert."
    PrintFensterLn fen, "P            = Spieler plazieren"
    PrintFensterLn fen, "T            = Eingabe Spielzeit"
    PrintFensterLn fen, "L            = Level laden"
    PrintFensterLn fen, "S            = Level speichern"
    PrintFensterLn fen, "C            = Level lschen"
    PrintFensterLn fen, "Esc          = Editor verlassen"
    d$ = INPUT$(1)
    LoescheFenster fen
  END SELECT
LOOP UNTIL t$ = CHR$(27)
Zch%(33) = 219
RETURN

FuehreElement:
LOCATE 1, 29
COLOR fa%(AktEl%), fh%(AktEl%)
PrintSpezZei Zch%(AktEl%)
RETURN

FuehreMalmodus:
LOCATE 1, 31
COLOR 15, 0
IF MalModus% THEN
  PRINT "M";
ELSE
  PRINT " ";
END IF
RETURN

' +-------+
' | Spiel |
' +-------+
Spielen:
DO
  COLOR 2, 0
  CLS
  LOCATE 10, 4
  PRINT "Geben Sie ein Passwort ein, um bei"
  LOCATE 11, 4
  PRINT "einem hheren Level zu starten"
  COLOR 11
  P% = 0
  DO
    LOCATE 13, 16
    PRINT pwd$;
    LOCATE , 16 + P%, 1
    DO
      t$ = INKEY$
    LOOP WHILE t$ = ""
    LOCATE , , 0
    SELECT CASE t$
    CASE CHR$(0) + "K", CHR$(8)
      P% = (P% + 5) MOD 6
    CASE CHR$(0) + "M", " "
      P% = (P% + 1) MOD 6
    CASE "0" TO "9"
      MID$(pwd$, P% + 1) = t$
      P% = (P% + 1) MOD 6
    CASE "A" TO "Z", "a" TO "v"
      MID$(pwd$, P% + 1) = UCASE$(t$)
      P% = (P% + 1) MOD 6
    END SELECT
  LOOP UNTIL t$ = CHR$(13) OR t$ = CHR$(27)
  IF t$ = CHR$(27) THEN EXIT DO
  AktLevel% = PruefePasswort(pwd$)
  IF AktLevel% < 1 OR AktLevel% > 99 THEN
    AktLevel% = 1
    pwd$ = GenerierePasswort$(1)
  END IF
  LadeLevel
  FOR i% = 0 TO 4
    tFoerdb!(i%) = FoerdbGesch!(i%)
    AnzSchl%(i%) = 0
  NEXT i%
  ZeichneLevel -1

  lebend% = -1
  Drinbleib% = -1
  nichtFertig% = -1
  PillenZeit% = 0
  LOCATE ySp%, xSp%
  COLOR 31, fh%(f%(xSp%, ySp%))
  PRINT CHR$(2);
  dummy$ = INPUT$(1)
  ZeichneZelle xSp%, ySp%
  tBas! = TIMER
  tZeit! = 0!
  WHILE nichtFertig% AND Drinbleib% AND lebend%
    ' Spieler abfragen: Damit "Multitasking" mglich wird, darf keine
    ' Schleife um INKEY$ gebildet werden, denn die Feinde mssen auch
    ' bewegt werden, wenn der Spieler keine Taste drckt! Hinweis fr
    ' eine Umsetzung in VisualBasic: Dort muss man noch zustzlich einen
    ' sog. Timer-Event zum Keyboard-Event setzen, welcher zu
    ' demjenigen Zeitpunkt auftreten soll, wenn ein Feind bewegt werden soll
    ' oder sonst etwas Zeitgetriggertes (Frderband) bewegt werden soll
    ax% = xSp%
    ay% = ySp%
    t$ = INKEY$
    SELECT CASE t$
    CASE CHR$(0) + "M"
      IF RichtungMoeglich%(xSp%, ySp%, 0, 0) THEN
        xSp% = xSp% + 1
      END IF
    CASE CHR$(0) + "H"
      IF RichtungMoeglich%(xSp%, ySp%, 0, 1) THEN
        ySp% = ySp% - 1
      END IF
    CASE CHR$(0) + "K"
      IF RichtungMoeglich%(xSp%, ySp%, 0, 2) THEN
        xSp% = xSp% - 1
      END IF
    CASE CHR$(0) + "P"
      IF RichtungMoeglich%(xSp%, ySp%, 0, 3) THEN
        ySp% = ySp% + 1
      END IF
    CASE "P", "p", " "
      t1! = TIMER
      Meldung "Pausenmodus"
      FOR i% = 1 TO AnzFei%
        ZeichneFeind fe(i%)
      NEXT i%
      ZeichneZelle xSp%, ySp%
      t2! = TIMER - t1!
      tBas! = tBas! + t2!
    CASE "S", "s"
      Snd% = NOT Snd%
    CASE CHR$(27)
      Drinbleib% = 0
    END SELECT
    t! = TIMER - tBas!
    IF xSp% <> ax% OR ySp% <> ay% THEN
      Bwg% = -1
      GOSUB FeldAuswerten
    ELSE
      IF Snd% AND t$ <> "" THEN
        SOUND 110, .3
      END IF
    END IF

    ' Feinde bei Bedarf bewegen
    FOR i% = 1 TO AnzFei%
      IF t! >= fe(i%).naechstBew THEN
        ' nchste Bewegung fllig
        IF fe(i%).istGefressen THEN
          ' Gefressener Feind: Umherirren
          h% = 0
          r% = -1
          FOR j% = 0 TO 3
            IF RichtungMoeglich(fe(i%).x, fe(i%).y, -1, j%) THEN
              h% = h% + 1
              IF RND * CSNG(h%) <= 1! THEN
                r% = j%
              END IF
            END IF
          NEXT j%
        ELSE
          ' Bewegungsstrategie: Feinde steuern immer Richtung Spieler,
          ' sofern dieser keine Kraftpille eingenommen hat, im anderen
          ' Fall rennen sie vom Spieler weg. Gelingt dies nicht, so
          ' laufen sie in eine zufllige freie Richtung
          ' Mit XOR wird die Bedingung bei Bedarf verdreht
          IF xSp% > fe(i%).x XOR PillenZeit% > 0 THEN
            rx% = 0
          ELSE
            rx% = 2
          END IF
          IF ySp% > fe(i%).y XOR PillenZeit% > 0 THEN
            ry% = 3
          ELSE
            ry% = 1
          END IF
          tx% = RichtungMoeglich(fe(i%).x, fe(i%).y, -1, rx%)
          ty% = RichtungMoeglich(fe(i%).x, fe(i%).y, -1, ry%)
          IF tx% AND ty% THEN
            ' Beide Richtungen mglich => wrfeln
            IF RND > .5 THEN
              r% = rx%
            ELSE
              r% = ry%
            END IF
          ELSEIF tx% THEN
            r% = rx%
          ELSEIF ty% THEN
            r% = ry%
          ELSE
            ' Hindernis im Weg => Rckwrtsbewegung
            rx% = rx% XOR 2
            ry% = ry% XOR 2
            tx% = RichtungMoeglich(fe(i%).x, fe(i%).y, -1, rx%)
            ty% = RichtungMoeglich(fe(i%).x, fe(i%).y, -1, ry%)
            IF tx% AND ty% THEN
              ' Beide Richtungen mglich => wrfeln
              IF RND > .5 THEN
                r% = rx%
              ELSE
                r% = ry%
              END IF
            ELSEIF tx% THEN
              r% = rx%
            ELSEIF ty% THEN
              r% = ry%
            ELSE
              r% = -1  ' Feind ist gefangen und bleibt einfach stehen
            END IF
          END IF
        END IF
        IF r% <> -1 THEN
          f%(fe(i%).x, fe(i%).y) = f%(fe(i%).x, fe(i%).y) AND 127 ' lschen
          ZeichneZelle fe(i%).x, fe(i%).y
          fe(i%).x = fe(i%).x + sx%(r%)
          fe(i%).y = fe(i%).y + sy%(r%)
          f%(fe(i%).x, fe(i%).y) = f%(fe(i%).x, fe(i%).y) OR 128
          ZeichneFeind fe(i%)
          GOSUB PruefeKollision
        END IF
        fe(i%).naechstBew = fe(i%).naechstBew + FeindGeschw!(fe(i%).geschKat)
      END IF
      ' Zustandsvernderungen
      IF fe(i%).istGefressen AND t! >= fe(i%).endeGefressen THEN
        ' Feind ist wieder "auferstanden"
        fe(i%).istGefressen = 0
        ZeichneFeind fe(i%)
        IF Snd% THEN
          FOR j% = 200 TO 600 STEP 50
            SOUND 4 * j%, .3
            SOUND 3 * j%, .3
            SOUND 2 * j%, .1
          NEXT j%
        END IF
      END IF
    NEXT i%
    ' Spieler und Feinde auf dem Frderband bewegen
    h% = 0
    FOR i1% = 0 TO 4
      IF t! >= tFoerdb!(i1%) THEN
        ' Spieler bewegen
        IF (f%(xSp%, ySp%) - 12 AND 124) = 4 * i1% THEN
          r% = f%(xSp%, ySp%) AND 3
          IF RichtungMoeglich(xSp%, ySp%, 0, r%) THEN
            ax% = xSp%
            ay% = ySp%
            xSp% = xSp% + sx%(r%)
            ySp% = ySp% + sy%(r%)
            IF Snd% THEN
              FOR j% = 1 TO 3
                SOUND 400, 1.5 * FoerdbGesch!(i1%)
                SOUND 0, 1.5 * FoerdbGesch!(i1%)
              NEXT j%
            END IF
            Bwg% = 0
            GOSUB FeldAuswerten
          ELSE
            IF Snd% THEN
              SOUND 62, 10! * FoerdbGesch!(i1%)
            END IF
          END IF
        END IF
        ' Feinde ebenfalls
        FOR j% = 1 TO AnzFei%
          IF (f%(fe(j%).x, fe(j%).y) - 12 AND 124) = 4 * i1% THEN
            r% = f%(fe(j%).x, fe(j%).y) AND 3
            IF RichtungMoeglich(fe(j%).x, fe(j%).y, 0, r%) THEN
              f%(fe(j%).x, fe(j%).y) = f%(fe(j%).x, fe(j%).y) AND 127
              ZeichneZelle fe(j%).x, fe(j%).y
              fe(j%).x = fe(j%).x + sx%(r%)
              fe(j%).y = fe(j%).y + sy%(r%)
              f%(fe(j%).x, fe(j%).y) = f%(fe(j%).x, fe(j%).y) OR 128
              h% = -1
            END IF
          END IF
        NEXT j%
        tFoerdb!(i1%) = tFoerdb!(i1%) + FoerdbGesch!(i1%)
      END IF
    NEXT i1%
    IF h% AND (f%(xSp%, ySp%) AND 128) <> 0 THEN
      i% = 0
      GOSUB PruefeKollision
    END IF
    ' Zeit aktualisieren
    IF t! >= tZeit! AND Zeit% > 0 THEN
      AktualisiereZeit -1
      tZeit! = tZeit! + 1!
      IF Zeit% = 0 THEN
        lebend% = 0
      END IF
    END IF
    ' Pillenwirkzeit
    IF t! >= tPillenzeit! AND PillenZeit% > 0 THEN
      AktualisierePillenzeit -1
      IF PillenZeit% = 0 THEN
        ' Pillenwirkung hat soeben aufgehrt
        FOR i% = 1 TO AnzFei%
          ZeichneFeind fe(i%)
        NEXT i%
        IF Snd% THEN
          FOR i% = 1 TO 3
            FOR j% = 10 TO 2 STEP -1
              SOUND 50 * j%, .2
              SOUND 20 * j%, .2
            NEXT j%
          NEXT i%
        END IF
      ELSE
        tPillenzeit! = tPillenzeit! + 1!
      END IF
    END IF
  WEND

  IF NOT lebend% THEN
    FOR i% = 250 TO 150 STEP -10
      LOCATE ySp%, xSp%
      COLOR 1 + CINT(INT(15! * RND(1))), fh%(f%(xSp%, ySp%) AND 127)
      PRINT CHR$(1 + CINT(INT(2! * RND)));
      IF Snd% THEN
        SOUND 3 * i%, 1
      END IF
      LOCATE ySp%, xSp%
      COLOR 1 + CINT(INT(15! * RND(1)))
      PRINT CHR$(1 + CINT(INT(2! * RND)));
      IF Snd% THEN
        SOUND 2 * i%, 1
      END IF
    NEXT i%
    LOCATE ySp%, xSp%
    COLOR 4
    PRINT CHR$(15);
    IF Snd% THEN
      PLAY "t200o2l4g>c<g>cd#dc<l2b>l4cl2c"
    END IF
  ELSEIF NOT nichtFertig% THEN
    LOCATE 13, 10
    IF Snd% THEN
      PLAY "t200o3l8ceg>c<dfa>d<bab>l2c"
    END IF
    AktLevel% = AktLevel% + 1
    pwd$ = GenerierePasswort(AktLevel%)
    Meldung "Level beendet. Passwort: " + pwd$
  END IF
LOOP
RETURN

' Feld, wo der Spieler daraufkommt, auswerten
FeldAuswerten:
IF f%(ax%, ay%) AND 128 THEN
  i% = 1
  WHILE fe(i%).x <> ax% OR fe(i%).y <> ay%
    i% = i% + 1
  WEND
  ZeichneFeind fe(i%)
ELSE
  ZeichneZelle ax%, ay%
END IF
ZeichneZelle xSp%, ySp%
' Verwerten
h% = f%(xSp%, ySp%)
IF h% AND 128 THEN
  i% = 0
  GOSUB PruefeKollision
ELSE
  SELECT CASE h%
  CASE 34, 42
    ' Geschafft! :-)
    nichtFertig% = 0
  CASE 35 TO 39
    IF PillenZeit% = 0 THEN
      tPillenzeit! = t! + 1!
      AktualisierePillenzeit PillWirk%(h% - 35)
      FOR i% = 1 TO AnzFei%
        ZeichneFeind fe(i%)
      NEXT i%
      IF Snd% THEN
        PLAY "t130o2l16egggl8fl16el8g"
      END IF
    ELSE
      AktualisierePillenzeit PillWirk%(h% - 35)
      IF Snd% THEN
        FOR i% = 1 TO 3
          SOUND 330, .5
          SOUND 392, .5
        NEXT i%
      END IF
    END IF
  CASE 40
    AktualisierePerlen -1
    IF Snd% THEN
      SOUND 880! * 2! ^ (1! / 4!), 2!
      IF AnzPerl% = 0 THEN
        PLAY "t240o2l8g>cegl16ggl8ggec<g"
      END IF
    END IF
  CASE 41
    IF Zeit% > 0 THEN   ' nur bei Zeitlimit
      AktualisiereZeit 5
    END IF
    IF Snd% THEN
      PLAY "t200o4l16ecd<g"
    END IF
  CASE 43 TO 47
    IF Snd% THEN
      FOR i% = 1 TO 3
        SOUND 262, .5
        SOUND 349, .5
        SOUND 440, .5
      NEXT i%
    END IF
    AktualisiereSchluessel h% - 43, 1
  CASE 48
    ' Leider in die Falle getreten! :-(
    lebend% = 0
  CASE 49 TO 53
    IF Snd% THEN
      FOR i% = 0 TO 5
        SOUND 58, .4
        SOUND 0, .2
      NEXT i%
    END IF
    AktualisiereSchluessel h% - 49, -1
  CASE ELSE
    IF Snd% AND Bwg% THEN
      SOUND 80, .1
    END IF
  END SELECT
  IF h% >= 35 AND h% <= 53 AND h% <> 42 THEN
    ' Gegenstand entfernen
    f%(xSp%, ySp%) = 32
    ZeichneZelle xSp%, ySp%
  END IF
END IF
RETURN

' Kollision Spieler-Feind berprfen und behandeln
PruefeKollision:
IF i% = 0 THEN
  i% = 1
  WHILE fe(i%).x <> xSp% OR fe(i%).y <> ySp%
    i% = i% + 1
  WEND
END IF

IF fe(i%).x = xSp% AND fe(i%).y = ySp% THEN
  IF NOT fe(i%).istGefressen THEN
    IF PillenZeit% > 0 THEN
      ' Feind fressen
      fe(i%).istGefressen = -1
      fe(i%).endeGefressen = t! + CSNG(PillWirk%(fe(i%).geschKat))
      IF Snd% THEN
        FOR j% = 500 TO 2000 STEP 30
          SOUND j%, .1
        NEXT j%
      END IF
      ZeichneFeind fe(i%)
    ELSE
      ' Leider in den Feind gerannt! :-(
      lebend% = 0
    END IF
  END IF
END IF
RETURN

' +-----------+
' | Anleitung |
' +-----------+

Anleitung:
Seite% = 1
DO
  COLOR 2, 0
  CLS
  PRINT "Anleitung Zelda 2 - Seite"; Seite%; " von 4"
  COLOR 1
  PRINT STRING$(39, 205)
  COLOR 7
  SELECT CASE Seite%
  CASE 1
    PRINT "Sie sind Zelda ";
    COLOR 15
    PRINT CHR$(2);
    COLOR 7
    PRINT ", der nach Juwelen ";
    COLOR 11
    PRINT CHR$(4);
    COLOR 7
    PRINT "suchende Strahler. Ihre Aufgabe ist es,"
    PRINT "alle ";
    COLOR 11
    PRINT strung$(2, 4);
    COLOR 7
    PRINT " Juwelen einzusammeln, und an-"
    PRINT "schliessend den Raum durch das Tor ";
    COLOR 15, 3
    PRINT CHR$(127);
    COLOR 7, 0
    PRINT " zu"
    PRINT "verlassen. ";
    COLOR 3
    PRINT "";
    COLOR 15
    PRINT "014";
    COLOR 7
    PRINT " am oberen Bildschirm-"
    PRINT "rand zeigt dabei die noch verbleibenden"
    PRINT "Juwelen an."
    PRINT
    PRINT "Doch aufgepasst: In den Juwelenhhlen"
    PRINT "lauern Ihnen Feinde ";
    FOR i% = 54 TO 58
      COLOR fa%(i%)
      PRINT CHR$(2);
    NEXT i%
    COLOR 7
    PRINT " auf, dabei"
    PRINT "sind ";
    COLOR 2
    PRINT CHR$(2);
    COLOR 7
    PRINT " am langsamsten, ";
    COLOR 14
    PRINT CHR$(2);
    COLOR 7
    PRINT " am schnellsten"
    PRINT "und damit am gefhrlichsten. Ebenso"
    PRINT "sollten Sie die Stromschlagfallen ";
    COLOR 14
    PRINT "#"
    COLOR 7
    PRINT "vermeiden. Gegen die Feinde gibt es zum"
    PRINT "Glck Kraftpillen ";
    FOR i% = 35 TO 39
      COLOR fa%(i%)
      PrintSpezZei 7
    NEXT i%
    COLOR 7
    PRINT " (";
    COLOR 9
    PrintSpezZei 7
    COLOR 7
    PRINT "=lngste"
    PRINT "Wirkdauer, ";
    COLOR 14
    PrintSpezZei 7
    COLOR 7
    PRINT "=krzeste Wirkdauer). Damit"
    PRINT "knnen die vor Zelda fliehenden Feinde"
    COLOR 2
    PRINT CHR$(1);
    COLOR 4
    PRINT CHR$(1);
    COLOR 7
    PRINT " fr kurze Zeit unschdlich gemacht"
    COLOR 2
    PRINT "";
    COLOR 4
    PRINT "";
    COLOR 7
    PRINT " werden. Dabei zeigt ";
    COLOR 13
    PrintSpezZei 7
    COLOR 15
    PRINT "14";
    COLOR 7
    PRINT " die verblei-"
    PRINT "bende Pillenwirkdauer an, welche bei"
    COLOR 9
    PrintSpezZei 7
    COLOR 8
    PRINT "--";
    COLOR 7
    PRINT " abgelaufen ist."
  CASE 2
    PRINT "In manchen Rumen ist noch zustzlich"
    PRINT "der Sauerstoff sehr knapp, was oben an"
    PRINT "als Uhr ";
    COLOR 14
    PRINT "t";
    COLOR 15
    PRINT "01:07";
    COLOR 7
    PRINT " angezeigt wird, wobei"
    PRINT "bei gut belfteten Rumen als ";
    COLOR 14
    PRINT "t";
    COLOR 8
    PRINT "--:--"
    COLOR 7
    PRINT "angezeigt wird. Doch glcklicherweise"
    PRINT "befinden sich Sauerstoffportionen ";
    COLOR 3
    PRINT STRING$(2, 6);
    COLOR 7
    PRINT " an"
    PRINT "manchen Stellen, welche den Vorrat um"
    PRINT "je 5 Sekunden verlngern."
    PRINT ""
    PRINT "An manchen Stellen befinden sich Tren"
    FOR i% = 49 TO 53
      COLOR fa%(i%)
      PRINT "";
    NEXT i%
    COLOR 7
    PRINT ", fr die man je einen Schlssel"
    FOR i% = 43 TO 47
      COLOR fa%(i%)
      PRINT "";
    NEXT i%
    COLOR 7
    PRINT " braucht. Da die Schlssel aufge-"
    PRINT "braucht werden, wird oben die aufge-"
    PRINT "sammelte Anzahl der jeweiligen Farbe"
    PRINT "als ";
    FOR i% = 43 TO 47
      COLOR fa%(i%)
      PRINT "";
      COLOR 15
      PRINT "01 ";
    NEXT i%
    COLOR 7
    PRINT "angezeigt."
  CASE 3
    PRINT "Manche Hhlenwege ";
    COLOR , 1
    PRINT STRING$(2, 26); CHR$(24);
    COLOR 10
    PRINT STRING$(2, 26); CHR$(24);
    COLOR 12
    PRINT STRING$(2, 26); CHR$(24);
    COLOR 7, 0
    PRINT " knnen nur"
    PRINT "in Pfeilrichtung wie Einbahnstrassen"
    PRINT "passiert werden. Die Pfeilfarbe be-"
    PRINT "stimmt dabei die Bewegungsfreiheit in"
    PRINT "der Querrichtung; bei den grauen"
    PRINT "Pfeilen ";
    COLOR , 1
    PRINT CHR$(25); STRING$(2, 27);
    COLOR , 0
    PRINT " kann man beliebig seitlich"
    PRINT "hinaus- und hereingehen, was bei den"
    PRINT "grnen Pfeilen ";
    COLOR 10, 1
    PRINT CHR$(25); STRING$(2, 27);
    COLOR 7, 0
    PRINT " nicht mglich ist."
    PRINT "Bei den roten Pfeilen ";
    COLOR 12, 1
    PRINT CHR$(24); STRING$(2, 27);
    COLOR 7, 0
    PRINT " kommt man"
    PRINT "immerhin seitlich herein, aber nicht"
    PRINT "mehr seitlich hinaus. ";
    COLOR 12, 1
    PRINT STRING$(2, 26);
    COLOR 14, 0
    PRINT "#";
    COLOR 7
    PRINT " ist also eine"
    PRINT "ziemlich sichere Todesfalle. Die Feinde"
    PRINT "unterliegen dabei denselben Bewegungs-"
    PRINT "freiheitsgesetzen."
    PRINT ""
    PRINT "Ganz selten kann ein Raum auch durch"
    PRINT "ein Superziel ";
    COLOR 5, 3
    PRINT CHR$(127);
    COLOR 7, 0
    PRINT " vorzeitig beendet"
    PRINT "werden, so dass nicht alle Juwelen"
    PRINT "bentigt werden."
  CASE 4
    PRINT "Ein weiteres Hindernis stellen rollende"
    PRINT "Frderbnder ";
    FOR i% = 12 TO 28 STEP 4
      COLOR fa%(i%), 7
      PRINT STRING$(3, 16);
    NEXT i%
    COLOR 7, 0
    PRINT " dar, deren"
    PRINT "Farbe ";
    FOR i% = 12 TO 28 STEP 4
      COLOR fa%(i%), 7
      PRINT CHR$(16);
    NEXT i%
    COLOR 7, 0
    PRINT " Auskunft ber die Geschwin-"
    PRINT "digkeit gibt: ";
    COLOR 9, 7
    PRINT STRING$(3, 16);
    COLOR 7, 0
    PRINT "=am langsamsten,"
    COLOR 14, 7
    PRINT STRING$(3, 16);
    COLOR 7, 0
    PRINT "=am schnellsten. Ansonsten kann man"
    PRINT "sich auf Frderbnder frei bewegen,"
    PRINT "ebenso sind auch die Feinde der Frder-"
    PRINT "bandbewegung ausgesetzt."
    PRINT ""
    PRINT "Bei jedem Level erhalten Sie ein Pass-"
    PRINT "wort, um spter fortsetzen zu knnen."
    PRINT "Steuerung von Zelda mit den Pfeiltasten"
    COLOR 4, 7
    PRINT CHR$(24);
    COLOR 7, 0
    PRINT "/";
    COLOR 4, 7
    PRINT CHR$(27);
    COLOR 7, 0
    PRINT "/";
    COLOR 4, 7
    PRINT CHR$(25);
    COLOR 7, 0
    PRINT "/";
    COLOR 4, 7
    PRINT CHR$(26);
    COLOR 7, 0
    PRINT ", mit ";
    COLOR 4, 7
    PRINT "P";
    COLOR 7, 0
    PRINT " oder ";
    COLOR 4, 7
    PRINT " Leertaste ";
    COLOR 7, 0
    PRINT " kann "
    PRINT "Spiel kurzzeitig in den Pausenmodus"
    PRINT "gesetzt werden, mit ";
    COLOR 4, 7
    PRINT "Esc";
    COLOR 7, 0
    PRINT " ist ein vorzei-"
    PRINT "tiger Abbruch jederzeit mglich, und mit"
    COLOR 4, 7
    PRINT "S";
    COLOR 7, 0
    PRINT " kann der Ton ein- und ausgeschaltet"
    PRINT "werden."
    PRINT
    PRINT "Und nun viel Spass und Erfolg! :-)"
  END SELECT
  LOCATE 25, 1
  COLOR 4, 7
  PRINT "BILD"; CHR$(24);
  COLOR 7, 0
  PRINT "/";
  COLOR 4, 7
  PRINT "BILD"; CHR$(25);
  COLOR 7, 0
  PRINT " blttern, ";
  COLOR 4, 7
  PRINT "Esc";
  COLOR 7, 0
  PRINT " Verlassen";
  LOCATE 24, 1
  COLOR 1
  PRINT STRING$(39, 205);
  DO
    t1$ = INKEY$
  LOOP WHILE t1$ = ""
  SELECT CASE t1$
  CASE CHR$(0) + "G"
    Seite% = 1
  CASE CHR$(0) + "O"
    Seite% = 4
  CASE CHR$(0) + "H", CHR$(0) + "I"
    Seite% = (Seite% - 2 AND 3) + 1
  CASE CHR$(0) + "P", CHR$(0) + "Q"
    Seite% = (Seite% AND 3) + 1
  CASE "S", "s"
    Snd% = NOT Snd%
  END SELECT
LOOP UNTIL t1$ = CHR$(27) OR t1$ = CHR$(13)
RETURN

SUB AktualisierePerlen (i%)
  AnzPerl% = AnzPerl% + i%
  LOCATE 1, 37
  COLOR 15, 0
  PRINT FuehrNull$(AnzPerl%, 3);
END SUB

SUB AktualisierePillenzeit (i%)
  PillenZeit% = PillenZeit% + i%
  LOCATE 1, 12
  IF PillenZeit% > 0 THEN
    COLOR 13, 0
    PrintSpezZei 7
    IF PillenZeit% > 3 THEN
      COLOR 15
    ELSE
      COLOR 12
    END IF
    PRINT FuehrNull$(PillenZeit%, 2);
  ELSE
    COLOR 9, 0
    PrintSpezZei 7
    COLOR 8
    PRINT "--";
  END IF
END SUB

SUB AktualisiereSchluessel (n%, i%)
  AnzSchl%(n%) = AnzSchl%(n%) + i%
  LOCATE 1, 17 + 4 * n%
  COLOR 15, 0
  PRINT FuehrNull$(AnzSchl%(n%), 2);
END SUB

SUB AktualisiereZeit (i%)
  Zeit% = Zeit% + i%
  LOCATE 1, 6
  IF Zeit% <= 5 THEN
    COLOR 12, 0
  ELSE
    COLOR 15, 0
  END IF
  PRINT FuehrNull$(Zeit% \ 60, 2); ":"; FuehrNull$(Zeit% MOD 60, 2);
  IF Zeit% <= 5 AND Snd% THEN
    SOUND 440! * 2! ^ (5! / 3!), 1!
  END IF
END SUB

SUB ErzeugeFenster (f AS Fenster)
  LOCATE f.y1, f.x1
  l% = f.x2 - f.x1 - 1
  PRINT ""; STRING$(l%, 205); "";
  FOR i% = f.y1 + 1 TO f.y2 - 1
    LOCATE i%, f.x1
    PRINT ""; SPACE$(l%); "";
  NEXT i%
  LOCATE f.y2, f.x1
  PRINT ""; STRING$(l%, 205); "";
  f.cx = f.x1 + 1
  f.cy = f.y1 + 1
END SUB

FUNCTION FuehrNull$ (w%, B%)
  h$ = MID$(STR$(w%), 2)
  FuehrNull$ = STRING$(B% - LEN(h$), "0") + h$
END FUNCTION

FUNCTION GenerierePasswort$ (n%)
  ' Level-Prfsumme bilden in den hheren Bits
  LevCod& = CLNG(n%) + 256& * (CLNG(n%) * 3078037 + 227718 AND 4194303)
  ' Transformation mit sog. modularer Arithmetik vornehmen
  ' (=verhltnismssig einfacher Algorithmus aus der Kryptographie)
  co2& = 0&
  FOR i% = 1 TO 5
    co2& = 64& * co2& + ((LevCod& AND 63&) * 37& + 14& AND 63&)
    LevCod& = LevCod& \ 64&
  NEXT i%
  pw$ = ""
  FOR i% = 1 TO 6
    ' Transformation mit modularer Arithmetik ein zweites Mal
    c% = CINT(co2& AND 31&) * 23 + 5 AND 31
    IF c% < 10 THEN
      pw$ = CHR$(48 + c%) + pw$
    ELSE
      pw$ = CHR$(55 + c%) + pw$
    END IF
    co2& = co2& \ 32&
  NEXT i%
  GenerierePasswort$ = pw$
END FUNCTION

SUB LadeLevel
  dn$ = "LEVEL" + FuehrNull$(AktLevel%, 2) + ".DAT"
  ' Erstes OPEN dient nur als "File not found"-Test, da BINARY sonst
  ' ungefragt eine neue Datei der Lnge 0 anlegt => soll verhindert werden
  OPEN dn$ FOR INPUT AS 1
  CLOSE 1
  LoescheLevel  ' RAM-Speicher initialisieren
  OPEN dn$ FOR BINARY AS 1
  Kennung$ = INPUT$(6, 1)
  IF Kennung$ <> "Zelda2" THEN
    PRINT "Keine Zelda 2-Leveldatei"
    STOP
  END IF
  FOR i% = 3 TO 24
    FOR j% = 2 TO 38
      f%(j%, i%) = ASC(INPUT$(1, 1))
    NEXT j%
  NEXT i%
  xSp% = ASC(INPUT$(1, 1))
  ySp% = ASC(INPUT$(1, 1))
  Zeit% = CVI(INPUT$(2, 1))
  CLOSE 1
END SUB

SUB LoescheFenster (f AS Fenster)
  FOR y% = f.y1 TO f.y2
    FOR x% = f.x1 TO f.x2
      ZeichneZelle x%, y%
    NEXT x%
  NEXT y%
END SUB

SUB LoescheLevel
  FOR i% = 1 TO 39
    f%(i%, 2) = 33
    f%(i%, 25) = 33
  NEXT i%
  FOR i% = 3 TO 24
    f%(1, i%) = 33
    FOR j% = 2 TO 38
      f%(j%, i%) = 32
    NEXT j%
    f%(39, i%) = 33
  NEXT i%
  xSp% = 20
  ySp% = 13
  Zeit% = 0
END SUB

SUB Meldung (t$)
  COLOR 9, 0
  DIM fen AS Fenster
  fen.x1 = 20 - LEN(t$) \ 2
  fen.y1 = 12
  fen.x2 = fen.x1 + LEN(t$) + 1
  fen.y2 = 14
  ErzeugeFenster fen
  COLOR 12
  PrintFenster fen, t$
  d$ = INPUT$(1)
  LoescheFenster fen
END SUB

SUB PrintFenster (f AS Fenster, t$)
  LOCATE f.cy, f.cx
  PRINT t$;
  f.cx = f.cx + LEN(t$)
END SUB

SUB PrintFensterLn (f AS Fenster, t$)
  LOCATE f.cy, f.cx
  PRINT t$;
  f.cx = f.x1 + 1
  f.cy = f.cy + 1
END SUB

' Spezialzeichenausgabe: Erlaubt im Gegensatz zum direkten
' PRINT auch die Verwendung der nicht druckbaren Zeichen/Symbole
SUB PrintSpezZei (z%)
  x% = POS(0)
  y% = CSRLIN
  IF z% = 7 OR z% >= 9 AND z% <= 13 OR z% >= 28 AND z% <= 31 THEN
    PRINT " ";
    DEF SEG = &HB800
    POKE 80 * y% + 2 * x% - 82, z%
  ELSE
    PRINT CHR$(z%);
  END IF
END SUB

FUNCTION PruefePasswort% (pwd$)
  co1& = 0&
  FOR i% = 1 TO 6
    c% = ASC(MID$(pwd$, i%, 1)) - 48
    IF c% > 10 THEN
      c% = c% - 7
    END IF
    ' Rcktransformation (modulare Arithmetik) des 2. Schrittes
    co1& = 32& * co1& + CLNG(c% * 7 + 29 AND 31)
  NEXT i%
  cod& = 0&
  FOR i% = 1 TO 5
    ' Rcktransformation (modulare Arithmetik) des 1. Schrittes
    cod& = 64& * cod& + ((co1& AND 63&) * 45& + 10& AND 63&)
    co1& = co1& \ 64&
  NEXT i%
  ' daraus in den unteren Bits die Levelnummer ablesen
  n% = CINT(cod& AND 255&)
  ' Soll-Prfsumme fr diesen Level bilden
  LevCod& = CLNG(n%) + 256& * (CLNG(n%) * 3078037 + 227718 AND 4194303)
  ' Ist-Prfsumme muss bereinstimmen, sonst ist der Level-Code ungltig
  IF cod& = LevCod& THEN
    PruefePasswort% = n%
  ELSE
    PruefePasswort% = -1    ' ungltiges Levelpasswort
  END IF
END FUNCTION

' Test, ob Bewegung mglich ist
FUNCTION RichtungMoeglich% (xPos%, yPos%, istFeind%, ri%)
  ' Zuerst auf aktueller Position
  h% = f%(xPos%, yPos%) AND 127
  IF h% < 12 THEN
    ' Nur Pfeile knnen einschrnken, wo man gerade steht
    IF ri% = (h% AND 3) THEN
      ' Laufrichtung=Pfeilrichtung => immer mglich
      moe% = -1
    ELSEIF ri% = (h% + 2 AND 3) THEN
      ' Entgegengesetzte Laufrichtung => immer unmglich
      moe% = 0
    ELSE
      ' Querrichtung: Nur bei grauem Pfeil kann man seitlich weggehen
      moe% = h% < 4
    END IF
  ELSE
    moe% = -1  ' alle brigen Elemente schrnken nicht ein
  END IF
  IF moe% THEN
    h% = f%(xPos% + sx%(ri%), yPos% + sy%(ri%))
    SELECT CASE h%
    CASE 0 TO 11   ' Pfeil
      IF ri% = (h% AND 3) THEN
        ' Laufrichtung=Pfeilrichtung => immer mglich
        RichtungMoeglich% = -1
      ELSEIF ri% = (h% + 2 AND 3) THEN
        ' Entgegengesetzte Laufrichtung => immer unmglich
        RichtungMoeglich% = 0
      ELSE
        ' Querrichtung: Nur bei grnem Pfeil kommt man seitlich nicht hinein
        RichtungMoeglich% = h% < 8
      END IF
    CASE 12 TO 32   ' leeres Feld und Frderband: immer mglich
      RichtungMoeglich% = -1
    CASE 33  ' feste Wand ist immer nicht mglich
      RichtungMoeglich% = 0
    CASE 34  ' normales Ziel: nur Spieler, wenn keine brigen Perlen
      RichtungMoeglich% = AnzPerl% = 0 AND NOT istFeind%
    CASE 35 TO 48, 128 TO 160  ' Gegenstnde und Feinde selber:
      ' nur Spieler kommt darauf
      RichtungMoeglich% = NOT istFeind%
    CASE 49 TO 53   ' Tre => nur schlsselbesitzender Spieler
      RichtungMoeglich% = AnzSchl%(h% - 49) > 0 AND NOT istFeind%
    CASE ELSE  ' sollte nie vorkommen! :-)
      PRINT "Interner Fehler"
      STOP
    END SELECT
  ELSE
    RichtungMoeglich% = 0
  END IF
END FUNCTION

SUB SpeichereLevel
  OPEN "LEVEL" + FuehrNull$(AktLevel%, 2) + ".DAT" FOR OUTPUT AS 1
  PRINT #1, "Zelda2";  ' Kennung, das gltige Zelda 2-Leveldatei
  FOR i% = 3 TO 24
    FOR j% = 2 TO 38
      PRINT #1, CHR$(f%(j%, i%));
    NEXT j%
  NEXT i%
  PRINT #1, CHR$(xSp%); CHR$(ySp%); MKI$(Zeit%);
  CLOSE 1
END SUB

SUB ZeichneFeind (fei AS Feind)
  IF fei.x <> xSp% OR fei.y <> ySp% THEN
    LOCATE fei.y, fei.x
    COLOR fa%(54 + fei.geschKat), fh%(f%(fei.x, fei.y) AND 127)
    IF PillenZeit% > 0 THEN
      IF fei.istGefressen THEN
        PRINT "";
      ELSE
        PRINT CHR$(1);
      END IF
    ELSE
      IF fei.istGefressen THEN
        PRINT "";
      ELSE
        PRINT CHR$(2);
      END IF
    END IF
  END IF
END SUB

SUB ZeichneLevel (FuerSpiel%)
  ' die Listen werden dabei auch erzeugt
  AnzPerl% = 0
  AnzFei% = 0
  IF FuerSpiel% THEN
    COLOR 7, 0
    CLS
  END IF
  FOR y% = 2 TO 25
    FOR x% = 1 TO 39
      ZeichneZelle x%, y%
      IF FuerSpiel% THEN
        SELECT CASE f%(x%, y%)
        CASE 40
          AnzPerl% = AnzPerl% + 1
        CASE 54 TO 58
          AnzFei% = AnzFei% + 1
          fe(AnzFei%).x = x%
          fe(AnzFei%).y = y%
          fe(AnzFei%).geschKat = f%(x%, y%) - 54
          fe(AnzFei%).naechstBew = FeindGeschw!(fe(AnzFei%).geschKat) * RND
          fe(AnzFei%).istGefressen = 0
          f%(x%, y%) = 160  ' Feind-Bit gesetzt
        END SELECT
      END IF
    NEXT x%
  NEXT y%
  IF FuerSpiel% THEN
    ' Statuszeile ausgeben
    LOCATE 1, 1
    COLOR 7, 0
    PRINT "L";
    COLOR 15
    PRINT FuehrNull$(AktLevel%, 2);
    COLOR 14
    PRINT " t";
    COLOR 8
    PRINT "--:--    ";
    FOR i% = 43 TO 47
      COLOR fa%(i%): PRINT " ??";
    NEXT i%
    COLOR 11
    PRINT " "; CHR$(4); "???";
    IF Zeit% > 0 THEN
      AktualisiereZeit 0
    END IF
    AktualisierePillenzeit 0
    FOR i% = 0 TO 4
      AktualisiereSchluessel i%, 0
    NEXT i%
    AktualisierePerlen 0
  END IF
END SUB

SUB ZeichneZelle (x%, y%)
  LOCATE y%, x%
  h% = f%(x%, y%) AND 127
  IF x% = xSp% AND y% = ySp% THEN
    COLOR 15, fh%(h%)
    PRINT CHR$(2);
  ELSE
    COLOR fa%(h%), fh%(h%)
    PrintSpezZei Zch%(h%)
  END IF
END SUB

